<?php
if (!defined('ABSPATH')) exit;

function wpsl_render_invitation_modal($template_html) {
    ob_start();
    ?>
    <div id="wpsl-invite-modal" class="wpsl-modal" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,.45); z-index:100000;">
        <div class="wpsl-modal-card" role="dialog" aria-modal="true" aria-labelledby="wpsl-invite-title" style="background:#fff; max-width:900px; margin:40px auto; padding:16px; border-radius:6px; box-shadow:0 10px 30px rgba(0,0,0,.2);">
            <div style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
                <h2 id="wpsl-invite-title" style="margin:0;">Email Invitation</h2>
                <button type="button" id="wpsl-invite-close" class="button">Close</button>
            </div>
            <div style="display:flex; gap:16px; margin-top:12px; flex-wrap:wrap;">
                <div style="flex:1 1 320px; min-width:300px;">
                    <h3 style="margin:0 0 8px;">Recipients</h3>
                    <div id="wpsl-invite-recipients" style="max-height:320px; overflow:auto; border:1px solid #ccd0d4; padding:8px; border-radius:4px;"></div>
                    <div style="display:flex; gap:8px; margin-top:8px; align-items:center;">
                        <input type="email" id="wpsl-invite-add" placeholder="Add email" class="regular-text" style="flex:1 1 auto;" />
                        <button type="button" class="button" id="wpsl-invite-add-btn">Add</button>
                    </div>
                </div>
                <div style="flex:2 1 420px; min-width:360px;">
                    <h3 style="margin:0 0 8px;">Message</h3>
                    <p style="margin:0 0 6px;"><label>Subject: <input type="text" id="wpsl-invite-subject" class="regular-text" value="<?php echo esc_attr( get_option('wpsl_invite_subject', 'Live Stream Invitation') ); ?>" /></label></p>
                    <?php
                    if (function_exists('wp_editor')) {
                        wp_editor(
                            $template_html,
                            'wpsl-invite-message',
                            [
                                'textarea_name' => 'wpsl_invite_message',
                                'textarea_rows' => 12,
                                'media_buttons' => false,
                                'tinymce'       => true,
                                'quicktags'     => true,
                                'editor_height' => 240,
                            ]
                        );
                    } else {
                        echo '<textarea id="wpsl-invite-message" rows="12" style="width:100%; font-family:monospace;">' . esc_textarea($template_html) . '</textarea>';
                    }
                    ?>
                    <p class="description">Placeholders: {{viewer_url}}, {{stream_id}}, {{stream_title}}, {{start_time}}</p>
                </div>
            </div>
            <div style="margin-top:12px; display:flex; justify-content:space-between; gap:8px; align-items:center; flex-wrap:wrap;">
                <div style="display:flex; gap:10px; align-items:center;">
                    <span id="wpsl-invite-status" class="description"></span>
                </div>
                <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
                    <?php $preview_to = (function(){ $u=wp_get_current_user(); $e = ($u && $u->exists()) ? (string)$u->user_email : ''; if(!$e) $e = get_option('admin_email'); return $e; })(); ?>
                    <label class="description" for="wpsl-preview-to">Preview to:</label>
                    <input type="email" id="wpsl-preview-to" class="regular-text" value="<?php echo esc_attr($preview_to); ?>" placeholder="you@example.com" />
                    <button type="button" class="button" id="wpsl-invite-preview">Send Preview to Me</button>
                    <button type="button" class="button button-primary" id="wpsl-invite-apply">Save Selection</button>
                </div>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
