# Repository Guidelines

## Project Structure & Module Organization
- `wp-stream-live.php`: Main plugin. Registers CPT `wpsl_stream`, REST routes at `/wp-json/wpsl/v1`, admin menu/UI, and the `[wpsl_viewer]` shortcode.
- `assets/js/streamer.js`: Admin streaming UI (loaded as `type="module"`).
- `assets/js/viewer.js`, `assets/js/hls.min.js`, `assets/js/mediabunny.esm.js`: Viewer playback, chat client, and vendor libs.
- `assets/css/admin.css`, `assets/css/viewer.css`: Admin and viewer styles.
- Storage: HLS artifacts write to `wp-content/uploads/wpsl/{stream_id}`.

## Build, Test, and Development Commands
- Activate: `wp plugin activate stream-live`
- Deactivate: `wp plugin deactivate stream-live`
- Local server (optional): `wp server --host=localhost --port=8080`
- Reset chat table: `wp db query "TRUNCATE TABLE $(wp db prefix)wpsl_chat;"`
- Poll chat (example): `curl "https://example.com/wp-json/wpsl/v1/chat/poll?stream_id=123&after_id=0"`
Use the WP Admin “Stream Live” page to create a stream and auto-create a viewer page.

## Coding Style & Naming Conventions
- PHP: WordPress Coding Standards (tabs for indent; escape with `esc_*`; sanitize input; capability checks). Prefix hooks/meta/options with `wpsl_`.
- JS: ES modules, camelCase, avoid globals; prefix DOM ids/classes with `wpsl-`. Enqueue via `wp_enqueue_script`/`wp_enqueue_style` only.
- Optional tooling: run `phpcs --standard=WordPress` if available.

## Testing Guidelines
- No unit test suite yet; verify manually:
  - Admin: create/load stream, start/stop; debug panel logs.
  - Viewer: HLS playback starts; chat send/poll works.
  - REST: upload/cleanup/chat endpoints return expected JSON and enforce tokens.
- Include reproduction steps and affected URLs when filing issues.

## Commit & Pull Request Guidelines
- Commits: small, imperative, scoped (e.g., `admin: improve stream UI`, `rest: validate upload name`).
- PRs include: clear description, linked issues, screenshots (Admin + Viewer), REST samples if relevant, and upgrade notes for behavior changes.
- Bump the plugin header `Version:` when preparing a release.

## Security & Configuration Tips
- Keep token checks; restrict upload names; write only under `uploads/wpsl/{id}`.
- Escape all output; sanitize request data; use `manage_options` checks and nonces for admin actions.
- Avoid exposing directory listings; keep vendor libs local.
